 IF EXISTS ( SELECT * FROM sys.procedures WHERE name = 'P_EST_PROD_DESCONTOS' )
BEGIN
	DROP PROCEDURE P_EST_PROD_DESCONTOS
END
GO

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20231002
'Job.................:  
'Nome................: P_EST_PROD_DESCONTOS
'Objetivo............: RETORNAR DESCONTOS
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2024-05-10
'Alterado por........: Gerson Reis
=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
Tag #I002 - Merge @TP_ORIG_VENDA e @USA_DESCONTO_PROPZ_IDENT
*/


CREATE PROCEDURE [dbo].P_EST_PROD_DESCONTOS  ( 
													@CD_EMP          INT,					  	-- CODIGO DA EMPRESA       
													@CD_FILIAL       INT,					  	-- CODIGO DA FILIAL       
													@CD_PROD         MONEY ,				  	-- CODIGO DO PRODUTO       
													@CD_CONV         INT = 0,				  	-- CODIGO DO CONVENIO       
													@NR_CARTAO_FIDEL VARCHAR(30) = '',			-- NUMERO DO CARTAO FIDELIDADE       
													@EAN             INT = 0,				  	-- CODIGO DE BARRAS DO PRODUTO       
													@CD_CLI          INT    = 0,          		-- CODIGO DO CLIENTE       
													@QTDE_PROD       MONEY = 0,			  		-- QUANTIDADE DE PRODUTO SELECIONADO       
													@APPLICATION     INT = 0,			  		-- CODIGO DA APLICACAO QUE REQUISITOU  0-ORCAMENTO | 1-TELEVENDAS 
													@ID_PROMO        MONEY = 0,			  		-- CODIGO DA PROMOCAO 
													@IS_RECEITA      INT = 0,			  		-- INFORMADO RECEITA PARA PRODUTO       
													@CD_FRM_PGTO     INT = 0,		      		-- CODIGO DA FORMA DE PAGAMENTO     
													@IGNORED         INT = 0,			      	-- SERA REMOVIDO POR NAO SER NECESSARIO- - AGUARDANDO ALTERACOES NO PDV 
													@CD_VEND         INT = 0,				  	-- CODIGO DO VENDEDOR 
													@CD_PARCEIRO     INT = 0,    
													@TP_ORIG_VENDA   INT = 2,             -- TIPO DE ORIGEM DA VENDA   1 = LOJA  2 = TELEVENDAS (DEFAULT)
													@USA_DESCONTO_PROPZ_IDENT INT = 0	  -- USA DESCONTO PROPZ MASSIVA IDENTIFICADA		
													)
-- EXEC [P_EST_PROD_DESCONTOS] 1, 18, 13492, 0, '',0 , 1, 1, 0, 0, 0, 0 ,0,0,0,1,0
AS
BEGIN
	SET NOCOUNT ON;

	-- DECLARACAO DE VARIAVEIS
	DECLARE @TMP_CD_BARRA VARCHAR(13);
	DECLARE @IS_CTR_CUSTO_SEMAFARO INT = 0;
	DECLARE @IS_AGREGAR_DESC_QTDE INT = 0;
	DECLARE @HABILITA_PONTUACAO_VENDA INT = 0;
	DECLARE @AGREGAR_DESC_QTDE_EM VARCHAR(255) = '';
	DECLARE @TP_PROD INT = - 1;
	DECLARE @VLR_CUSTO MONEY = 0;
	DECLARE @QTDE_PONTO_FIDEL MONEY = 0;
	DECLARE @PERC_DESC_LIMITE MONEY = 0;
	DECLARE @QTDE_ESTOQUE INT = 0;
	DECLARE @QTD_PONTO_VENDA MONEY = 0;
	DECLARE @LMT_PROD_PONTO_VENDA MONEY = 0;
	DECLARE @CAMPANHA INT = 0;
	DECLARE @QTDE_PROD_CAMPANHA INT = 0;
	DECLARE @VALIDA_STS_CRED_CONV INT = 1;
	DECLARE @VALIDA_STS_CRED_CREDIARIO INT = 1;
	DECLARE @CD_TBL_DESC INT = 0;
	DECLARE @TP_DESC INT = 0;
	DECLARE @FLAG_DESC_FIX INT = 0;
	DECLARE @PERC_DESC MONEY = 0;
	DECLARE @PERC_DESC_MAX MONEY = 0;
	DECLARE @TP_NIVEL INT = 0;
	DECLARE @EXCLUE_OFERTA INT = 0;
	DECLARE @QT_MAX INT = 0;
	DECLARE @LIBERA_VD_CONV INT = 0;
	DECLARE @IS_CLI_FIDEL INT = 0;
	DECLARE @MES_DT_NASC_CLI INT = 0;
	DECLARE @DS_COR_RECEITA VARCHAR(255) = '';
	DECLARE @DS_TIPO_RECEITA VARCHAR(255) = '';
	DECLARE @AGREGACAO INT = 0;
	DECLARE @QTDE_PAG INT = 0;
	DECLARE @PERC_DESC_OFERTA MONEY = 0;
	DECLARE @PERC_DESC_OFERTA_MAX MONEY = 0;
	DECLARE @VLR_OFERTA MONEY = 0;
	DECLARE @VLR_TABELA MONEY = 0;
	DECLARE @USA_CARTAO_PARA_FIDELIDADE INT = 0;
	DECLARE @EXISTE_CAMPANHA_ATIVA INT = 1;-- POR PADRAO MOMENTANEO BUSCA CAMPANHA MESMO SEM EXISTIR 
	DECLARE @CLI_CREDIARIO INT = 0;
	DECLARE @CD_MDL_VD_CREDIARIO INT = 0;
	DECLARE @CD_MDL_VD_CONVENIO INT = 0;
	DECLARE @DESCONTO_ESPECIAL INT = 3;-- 0 DESCONTO DESTE CADASTRO; 1-CONVENIO; 2-CREDIARIO; 3-MELHOR DESCONTO 
	DECLARE @CD_FILIAL_BASE_DESC INT = 0;-- AQUI PASSA A FILIAL QUE VAI PEGAR O DESCONTO 
	DECLARE @PGTO_AVISTA INT = 0;-- SE O PAGAMENTO  A VISTA OU A PRAZO
	DECLARE @SOBREPOE_PRECO_OFERTA INT = 0;
	DECLARE @FLAG_SOMENTE_DESCONTO_CONV INT = 0;
	DECLARE @STS_PROD INT = 0;
	DECLARE @P INT = 0;
	DECLARE @HOJE DATE = GETDATE();
	DECLARE @PERMITE_DESC_OFERTA INT = 0;
	DECLARE @CD_FAMILIA INT = 0;
	DECLARE @FLAG_SOBREPOE_DESCONTOS INT = 0;
 	DECLARE @USA_DESC_EXCLUSIVO 	INT;
	DECLARE @TABELAS_EXCLUSIVAS 	INT;
	DECLARE @TP_TBL_DESC INT = 3;						  
	DECLARE @QTDE_LIMITE_VENDA_FAMILIA INT = 0;
	DECLARE @DS_FAMILIA VARCHAR(255) = '';
	DECLARE @ZERA_DESC_OFERTA INT = 0;


	-- CRIANDO TABELA TEMPORARIA DE RETORNO    
	CREATE TABLE #RS_RET (
		VERSAO VARCHAR(100)
		,CD_EMP INT
		,CD_FILIAL INT
		,CD_PROD INT
		,DS_PROD VARCHAR(100)
		,NM_FABRIC VARCHAR(100)
		,VLR_TABELA MONEY
		,VLR_OFERTA MONEY
		,QTDE_PONTO_FIDEL MONEY
		,CTR_PMC INT
		,LIB_DESC_VERBA INT
		,FLAG_REQUER_RECEIT INT
		,FLAG_ALTERAR_PRECO INT
		,PROD_USO_CONT INT
		,TP_PROD INT
		,VLR_CUSTO MONEY
		,CD_GRP INT
		,QTD_PONTO_VENDA MONEY
		,LMT_PROD_PONTO_VENDA MONEY
		,APRES_QT_VD INT
		,QTDE_ESTOQUE MONEY
		,DS_TIPO_RECEITA VARCHAR(100)
		,DS_COR_RECEITA VARCHAR(100)
		,PERC_DESC_LIMITE MONEY
		,CD_TRIB_FC VARCHAR(3)
		,PERC_ICMS_N_CONT_ESTA MONEY
		,PERC_RED_VD MONEY
		,LIBERA_VD_CONV INT
		,QTDE_PROD_MAX_CONV INT
		,FIXA_DESCONTO INT
		,TP_DESCONTO INT
		,VLR_ECONOMIA MONEY
		,DS_DESCONTO VARCHAR(150)
		,CD_TBL_DESC INT
		,TP_NIVEL INT
		,PERC_DESC MONEY
		,MAIOR_PERC_DESC MONEY
		,PRODUTO_CONTROLADO INT
		,VLR_PMC MONEY
		,TP_TBL_DESC  INT  DEFAULT( 3 )  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																												  
		
-- AVALIAR COLUNAS ABAIXO
		,FLAG_DESCONTO_TICKET_BLQ INT
		,PERC_DESC_FIDEL_MAX MONEY
		,PROMO_INDUSTRIA INT
		,PERC_DESC_ANIVER MONEY
		,PERC_DESC_CLAS MONEY
		,VLR_DESC_FABRIC MONEY
		,CAMPANHA INT
		,QTDE_PROD_CAMPANHA INT
		,FLAG_BLOQUEIA_DESCONTO INT
		,PERC_DESC_POS_PBM DECIMAL(6, 4)
		,CD_FAMILIA INT
		,NCM_PROD VARCHAR(50)
		,NR_REG_MS VARCHAR(150)
		,QTDE_LIMITE_VENDA_FAMILIA INT
		,DS_FAMILIA VARCHAR(255) 
-- COLUNAS PARA SEMAFRO NO TELEVENDAS
		,PERC_PIS MONEY
		,PERC_COFINS MONEY
		,EAN VARCHAR(50)
		);

	CREATE TABLE #TEMP_RS_TAB_DESC (
		CD_TBL_DESC INT
		,TP_DESC INT
		,FLAG_DESC_FIX INT
		,PERC_DESC MONEY
		,PERC_DESC_MAX MONEY
		,TP_NIVEL INT
		,TP_TBL_DESC  INT  DEFAULT( 3 )  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																												  
		);

	CREATE TABLE #TEMP_RS_TIPO_DESC_CAD (CD_TP_DESCONTO INT);


	
	IF @EAN = 1 
-- CONSULTANDO CODIGO DE BARRAS
	BEGIN
		SET @TMP_CD_BARRA = DBO.F_PAD_STRING(CAST(@CD_PROD AS BIGINT), '0', 13, 0);
		
		SET @CD_PROD = ( SELECT COALESCE(CD_PROD, 0) FROM EST_PROD_CD_BARRA WHERE CD_EMP   = @CD_EMP AND CD_BARRA = @TMP_CD_BARRA);


		IF @CD_PROD = 0 OR @CD_PROD IS NULL -- VERIFICA SE EXISTE PRODUTO
		BEGIN
			RAISERROR (
					N'PRODUTO NAO ENCONTRADO PARA O CODIGO DE BARRA %s',18
					,-- SEVERITY.
					1
					,-- STATE.
					@TMP_CD_BARRA
					);

			RETURN;
		END;
	END;

	SET @P = CAST(@CD_PROD AS INT);

	IF NOT EXISTS (SELECT 1
					 FROM EST_PROD_CPL
					WHERE CD_EMP    = @CD_EMP
					  AND CD_FILIAL = @CD_FILIAL
					  AND CD_PROD   = @CD_PROD )
	BEGIN
		RAISERROR (
				N'PRODUTO %d NAO ENCONTRADO PARA O FILIAL %d'
				,18
				,-- SEVERITY.
				1
				,-- STATE.
				@P
				,@CD_FILIAL
				);

		RETURN;
	END;


-- :::::::::: CAPTURANDO PARAMETROS DE CONFIGURACAO :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
	SET @IS_CTR_CUSTO_SEMAFARO		= COALESCE(( SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'CTR_CUSTO_SEMAFORO'), 0);
    SET @IS_AGREGAR_DESC_QTDE		= COALESCE(( SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'AGREGAR_DESC_QTDE'), 0);
    SET @AGREGAR_DESC_QTDE_EM		= COALESCE(( SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'AGREGAR_DESC_QTDE_EM'), 0);
	SET @VALIDA_STS_CRED_CONV		= COALESCE((SELECT COALESCE(CAST(VALOR AS INT), 1) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'VALIDA_STS_CRED_CONV'), 1);
	SET @VALIDA_STS_CRED_CREDIARIO  = COALESCE(( SELECT COALESCE(CAST(VALOR AS INT), 1) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'VALIDA_STS_CRED_CREDIARIO'), 1);
    SET @USA_CARTAO_PARA_FIDELIDADE = COALESCE((SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'USA_CARTAO_PARA_FIDELIDADE'), 0);
    SET @SOBREPOE_PRECO_OFERTA      = COALESCE(( SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'DESCONTO_SOBREPOE_PRECO_OFERTA'), 0);
  --SET @EXISTE_CAMPANHA_ATIVA      = COALESCE((SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'EXISTE_CAMPANHA_ATIVA')        , 0);
  --SET @EXISTE_CAMPANHA_ATIVA      = COALESCE((SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'EXISTE_CAMPANHA_ATIVA')        , 0);
	SET @CD_FILIAL_BASE_DESC = COALESCE((SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'CD_FILIAL_BASE_DESC'), 0);
	SET @PERMITE_DESC_OFERTA = COALESCE((SELECT COALESCE(CAST(VALOR AS INT), 0) FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE LIKE 'PERMITIR_DESCONTO_EM_PRODUTO_OFERTA'), 0);
	SET @PGTO_AVISTA = ISNULL(( SELECT TOP 1 CASE WHEN TP_COND = 0 THEN 1 ELSE 0 END FROM EST_FORMA_PGTO WHERE CD_FRM_PGTO = @CD_FRM_PGTO ), 1);
	SET @FLAG_SOMENTE_DESCONTO_CONV = 0;
-- ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


	IF @CD_CONV > 0
	BEGIN
		SET @FLAG_SOMENTE_DESCONTO_CONV = ISNULL(( SELECT FLAG_SOMENTE_DESC_CONTRATO FROM RC_CLI_CONV WHERE CD_EMP = @CD_EMP AND CD_CONV = @CD_CONV ), 0);
	END;

/*
	IF ( @CD_FRM_PGTO = ( SELECT CD_FRM_PGTO FROM EST_FORMA_PGTO WHERE DS_FRM_PGTO LIKE 'CONV%' ) )
	BEGIN
		SET @FLAG_SOMENTE_DESCONTO_CONV = 1;
	END;
*/
	-- CAPTURANDO DADOS PRODUTO
	SELECT @VLR_CUSTO        = ( CASE @IS_CTR_CUSTO_SEMAFARO WHEN 0 THEN PROD.VLR_CUSTO ELSE PROD.VLR_CUSTO_MD
						          END )
		  ,@TP_PROD          = COALESCE(PROD.TP_PROD, - 1)
		  ,@QTDE_PONTO_FIDEL = COALESCE(PROD.QTDE_PONTO_FIDEL, 0)
		  ,@QTDE_ESTOQUE     = COALESCE(PEND.QT_EST, 0) - COALESCE(PEND.QT_PEND_SAI, 0)
		  ,@STS_PROD         = CASE WHEN PEND.STS_PROD <> 1 THEN PEND.STS_PROD_FILIAL
		  			         		ELSE PEND.STS_PROD 
					         	END
	  FROM EST_PROD_CPL PROD
		   INNER JOIN V_EST_PROD_CPL_PENDENCIAS PEND ON PROD.CD_EMP = PEND.CD_EMP
													AND PROD.CD_FILIAL = PEND.CD_FILIAL
													AND PROD.CD_PROD = PEND.CD_PROD
	 WHERE PROD.CD_EMP    = @CD_EMP
	   AND PROD.CD_FILIAL = @CD_FILIAL
	   AND PROD.CD_PROD   = @CD_PROD;

	-- VALIDANDO
	IF NOT EXISTS ( SELECT 1 WHERE @TP_PROD IN ( 0 ,9 ,10 ,11 ) )
	BEGIN
		RAISERROR (
				N'VENDA DE PRODUTO COMO O TIPO %d NAO EH PERMITIDA.'
				,18
				,-- SEVERITY.
				1
				,-- STATE.
				@TP_PROD
				);

		RETURN;
	END;

	IF @STS_PROD = 1
	BEGIN
		RAISERROR (
				N'STATUS DO PRODUTO DESABILITADO PARA VENDA.'
				,18
				,-- SEVERITY.
				1
				,-- STATE.
				@TP_PROD
				);

		RETURN;
	END;

	-- ZERANDO ESTOQUE CASO ESTOQUE SEJA NEGATIVO
	SET @QTDE_ESTOQUE = CASE WHEN @QTDE_ESTOQUE < 0 THEN 0 ELSE @QTDE_ESTOQUE END;

	IF EXISTS ( SELECT 1 WHERE @TP_PROD IN ( 9,10 ,11 ))
		SET @QTDE_ESTOQUE = @QTDE_PROD;



	-- CAPTURA DE CAMPANHAS
	-- CAPTURA DE CAMPANHAS PONTOS VENDA
	IF @EXISTE_CAMPANHA_ATIVA = 1
	BEGIN
		SELECT TOP 1 @QTD_PONTO_VENDA = COALESCE(A.QT_PONTOS_TROCA, 0)
			,@LMT_PROD_PONTO_VENDA = COALESCE(A.QTDE_LIMITE_VENDA, 0)
			,@TP_TBL_DESC = 2   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																								  
		FROM PDV_CAMPANHA_ADICIONAIS_PONTUACAO_EST_PROD_CAMPANHA A
		INNER JOIN PDV_CAMPANHA_ADICIONAIS_PONTUACAO_PRC_FILIAL B ON A.CD_EMP = B.CD_EMP
			AND A.CD_CAMPANHA_ADIC = B.CD_CAMPANHA_ADIC
		JOIN PDV_CAMPANHA_ADICIONAIS C ON A.CD_EMP = C.CD_EMP    --- GUSTAVO AQUI
			AND A.CD_CAMPANHA_ADIC = C.CD_CAMPANHA_ADIC
		WHERE A.CD_EMP = @CD_EMP
			AND B.CD_FILIAL = @CD_FILIAL
			AND A.CD_PROD = @CD_PROD
			AND C.DT_INICIO <= @HOJE
			AND C.DT_VALID >= @HOJE
         AND C.ORIG_VENDA IN ( 0 , @TP_ORIG_VENDA )
		ORDER BY A.DT_VALID DESC;

		-- CAPTURA DE CAMPANHAS QUANTIDADE DE PRODUTO
		SELECT TOP 1 @CAMPANHA = COALESCE(A.CD_CAMPANHA_ADIC, 0)
			,@QTDE_PROD_CAMPANHA = COALESCE(B.QTDE_PROD, 0)
			,@TP_TBL_DESC = 2   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																								  
		FROM PDV_CAMPANHA_ADICIONAIS A            --- GUSTAVO AQUI
		INNER JOIN PDV_CAMPANHA_ADICIONAIS_EST_PROD_CAMPANHA B ON A.CD_EMP = B.CD_EMP
			AND A.CD_CAMPANHA_ADIC = B.CD_CAMPANHA_ADIC
		INNER JOIN PDV_CAMPANHA_ADICIONAIS_PRC_FILIAL C ON A.CD_EMP = C.CD_EMP
			AND A.CD_CAMPANHA_ADIC = C.CD_CAMPANHA_ADIC
		WHERE A.CD_EMP = @CD_EMP
			AND C.CD_FILIAL = @CD_FILIAL
			AND B.CD_PROD = @CD_PROD
			AND A.DT_INICIO <= @HOJE
			AND A.DT_VALID >= @HOJE
         AND A.ORIG_VENDA IN ( 0 , @TP_ORIG_VENDA )
		ORDER BY A.DT_VALID DESC;
	END;

	-- FIM CAPTURA DE CAMPANHA
	-- CAPTURA INFORMACOES DE TIPO DE RECEITA
	SELECT TOP 1 @DS_COR_RECEITA = COALESCE(B.DS_COR, '')
		,@DS_TIPO_RECEITA = COALESCE(C.DS_TP_RECEITA, '')
	FROM EST_PROD A
	LEFT JOIN GLB_COR_RECEITA B ON A.CD_EMP = B.CD_EMP
		AND A.CD_COR_RECEITA = B.CD_COR
	LEFT JOIN GLB_TP_RECEITA C ON A.CD_EMP = C.CD_EMP
		AND A.CD_TP_RECEITA = C.CD_TP_RECEITA
	WHERE A.CD_EMP = @CD_EMP
		AND A.CD_PROD = @CD_PROD;

	-- CAPTURA SE CLIENTE E FIDELIDADE PARA VALIDAR PONTUACAO
	SELECT TOP 1 @IS_CLI_FIDEL = COALESCE(A.FLAG_CLI_FIDEL, 0)
	FROM RC_CLI A
	WHERE A.CD_EMP = @CD_EMP
		AND A.CD_CLI = @CD_CLI;

	IF @USA_CARTAO_PARA_FIDELIDADE = 1
		AND @IS_CLI_FIDEL = 0
		IF @NR_CARTAO_FIDEL <> ''
			SET @IS_CLI_FIDEL = COALESCE((
						SELECT 1
						FROM RC_CLI_FIDELI_CARTAO A
						WHERE CD_EMP = @CD_EMP
							AND A.CD_CLI = @CD_CLI
							AND NR_CARTAO = @NR_CARTAO_FIDEL
						), 0);

	-- ZERANDO OS PONTOS PARA CLENTES NAO FIDELIDADE...
	IF @IS_CLI_FIDEL = 0
		SET @QTDE_PONTO_FIDEL = 0;
	SET @CLI_CREDIARIO = COALESCE((
				SELECT 1
				FROM RC_CLI_CREDIARIO
				WHERE CD_EMP = @CD_EMP
					AND CD_CLI = @CD_CLI
				), 0);
	SET @CD_MDL_VD_CREDIARIO = COALESCE((
				SELECT CD_MDL_VD
				FROM RC_CLI_CREDIARIO
				WHERE CD_EMP = @CD_EMP
					AND CD_CLI = @CD_CLI
				), 0);
	SET @CD_MDL_VD_CONVENIO = COALESCE((
				SELECT CD_MDL_VD
				FROM RC_CLI_CONV
				WHERE CD_EMP = @CD_EMP
					AND CD_CONV = @CD_CONV
				), 0);

	--VALIDANDO DESCONTO DIFERENCIADO PARA O TELEVENDAS /DROGAS MIL & CRUZEIRO
	IF @APPLICATION = 1
		AND @CD_FILIAL_BASE_DESC > 0
		SET @CD_FILIAL = @CD_FILIAL_BASE_DESC;
	--FIM
	--------------------------------------------------------------------------------------------------------------------------
	------ INCIANDO CAPTURA DE DESCONTOS -------------------------------------------------------------------------------------
	--------------------------------------------------------------------------------------------------------------------------
	
-- Tag #A001	
	--CAPTURANDO PERCENTUAL DE DESCONTO LIMITE;
	SET @PERC_DESC_LIMITE = COALESCE((
				SELECT COALESCE(PERC_DESC, 0)
				FROM UFD_EST_PROD_TBL_DESC_LIMITE(@CD_EMP, @CD_FILIAL, @CD_PROD , @TP_ORIG_VENDA )
				), 0);
	SET @CD_FAMILIA = COALESCE((
				SELECT ARV.CD_ARV_MERC_FAMILIA
				FROM EST_PROD_EST_ARV_MERCADOLOGICA ARV
				WHERE ARV.CD_EMP = @CD_EMP
					AND ARV.CD_PROD = @CD_PROD
				), 0);
				
	--- BUSCANDO QTDE LIMTE POR FAMILIA
	
	SET @QTDE_LIMITE_VENDA_FAMILIA = COALESCE(
												(SELECT FQTDE.QTDE_LIMITE_VENDA
												FROM EST_ARV_MERC_FAMILIA FQTDE
												WHERE FQTDE.CD_EMP = @CD_EMP
												AND FQTDE.CD_ARV_MERC_FAMILIA = @CD_FAMILIA), 0);
												
	SET @DS_FAMILIA = COALESCE(
												(SELECT FQTDE.DS_ARV_MERC_FAMILIA
												FROM EST_ARV_MERC_FAMILIA FQTDE
												WHERE FQTDE.CD_EMP = @CD_EMP
												AND FQTDE.CD_ARV_MERC_FAMILIA = @CD_FAMILIA), '');												

	-- CONSULTA BASICA DE PRODUTO
	INSERT INTO #RS_RET
	SELECT  '23/09/2020 01:00' AS VERSAO
		,@CD_EMP
		,@CD_FILIAL
		,@CD_PROD
		,PROD.DS_PROD
		,ISNULL(F.NM_FABRIC, '') NM_FABRIC
		,PRECO.VLR_TABELA
		,0
		,@QTDE_PONTO_FIDEL
		,PROD.CTR_PMC
		,COALESCE(COALESCE(PROD_C.FLAG_VERBA_DESCON, PROD.FLAG_VERBA_DESCON), 0)
		,PROD.FLAG_REQUER_RECEIT
		,PROD.FLAG_ALTERAR_PRECO
		,PROD.PROD_USO_CONT
		,@TP_PROD
		,@VLR_CUSTO
		,0
		,--CD_GRP GRUPO COMISSIONAMENTO VERIFICAR COM PEGAR ESTE VALOR
		@QTD_PONTO_VENDA
		,@LMT_PROD_PONTO_VENDA
		,COALESCE(PROD_C.APRES_QT_VD, 1)
		,@QTDE_ESTOQUE
		,@DS_COR_RECEITA
		,@DS_TIPO_RECEITA
		,@PERC_DESC_LIMITE
		,PROD_C.CD_TRIB_FC
		,PROD_C.PERC_ICMS_N_CONT_ESTA
		,PROD_C.PERC_RED_VD
		,0
		,--LIBERA_VD_CONV
		0
		,--QTDE_PROD_MAX_CONV
		0
		,--FIXA_DESCONTO
		0
		,--TP_DESCONTO
		0
		,--VLR_ECONOMIA
		''
		,--DS_DESCONTO
		0
		,--CD_TBL_DESC
		0
		,--TP_NIVEL
		0
		,--PERC_DESC
		0
		,--PERC_DESC_MAX
		CASE 
			WHEN PROD.FLAG_PRODUTO_CONTROLADO = 0
				THEN PROD.ANTIBIOTICO
			ELSE PROD.FLAG_PRODUTO_CONTROLADO
			END
		,TBL.VLR_VD
		,--VLR_PMC
		0
		,--( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)
		3 AS TP_TBL_DESC			 
		,--FLAG_DESCONTO_TICKET_BLQ INT,      
		0
		,--PERC_DESC_FIDEL_MAX MONEY,        
		0
		,--PROMO_INDUSTRIA  INT,         
		0
		,--PERC_DESC_ANIVER MONEY,      
		0
		,--PERC_DESC_CLAS  MONEY,     
		0
		,--VLR_DESC_FABRIC MONEY,		      
		@CAMPANHA
		,@QTDE_PROD_CAMPANHA
		,0
		,--FLAG_BLOQUEIA_DESCONTO INT
		DBO.UFD_EST_PROD_TBL_DESC_POS_PBM(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT )
		,@CD_FAMILIA
		,PROD.NR_NCM
		,PROD.NR_REG_MS
		,@QTDE_LIMITE_VENDA_FAMILIA
		,@DS_FAMILIA
		,PROD_C.PERC_PIS 
		,PROD_C.PERC_COFINS
		,'' AS EAN
	FROM EST_PROD PROD
	INNER JOIN --EST_PROD_CPL PROD_C ON
		--	PROD.CD_EMP  = PROD_C.CD_EMP AND 
		--	PROD.CD_PROD = PROD_C.CD_PROD INNER JOIN
		V_EST_PROD_CPL PROD_C ON PROD_C.CD_EMP = PROD.CD_EMP
		AND PROD_C.CD_FILIAL = @CD_FILIAL
		AND PROD_C.CD_PROD = PROD.CD_PROD
	INNER JOIN EST_PROD_PRECO PRECO ON PROD_C.CD_EMP = PRECO.CD_EMP
		AND PROD_C.CD_FILIAL = PRECO.CD_FILIAL
		AND PROD_C.CD_PROD = PRECO.CD_PROD
	LEFT JOIN EST_PROD_FABRIC F ON PROD.CD_FABRIC = F.CD_FABRIC
	LEFT JOIN EST_PROD_PRECO_TBL TBL ON PROD.CD_EMP = TBL.CD_EMP
		AND PROD.CD_PROD = TBL.CD_PROD
	WHERE PROD.CD_EMP = @CD_EMP
		AND PROD.CD_PROD = @CD_PROD;

	IF NOT EXISTS (
			SELECT 1
			FROM #RS_RET
			WHERE CD_EMP = @CD_EMP
				AND CD_FILIAL = @CD_FILIAL
				AND CD_PROD = @CD_PROD
			)
	BEGIN
		RAISERROR (
				N'PRODUTO %d NAO ENCONTRADO PARA O FILIAL %d MOTIVO PRODUTO SEM PRECO'
				,18
				,-- SEVERITY.
				1
				,-- STATE.
				@P
				,@CD_FILIAL
				);

		RETURN;
	END;

	--LIBERACAO RECEBIMENTO EM CONVENIO
	SET @LIBERA_VD_CONV = DBO.UFD_EST_PROD_LIBERA_PGTO_CONV(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_CLI, @CD_CONV, @IS_RECEITA);

	----ZERANDO VALOR OFERTA
	SET @ZERA_DESC_OFERTA = COALESCE(
							(SELECT
						B.CD_PROD
					FROM EST_PROD_ZERAR_DESCONTOS_OFERTA_TEMP A INNER JOIN EST_PROD_ZERAR_DESCONTOS_OFERTA_TEMP_EST_PROD B ON
						A.CD_EMP=B.CD_EMP AND
						A.CD_CTR=B.CD_CTR

					INNER JOIN EST_PROD_ZERAR_DESCONTOS_OFERTA_TEMP_PRC_FILIAL C ON
						C.CD_EMP=A.CD_EMP AND
						C.CD_CTR=A.CD_CTR

					WHERE A.CD_EMP=@CD_EMP
						AND C.CD_FILIAL=@CD_FILIAL
						AND B.CD_PROD= @CD_PROD
						AND CAST (A.DT_INI AS DATE )<= CAST (GETDATE() AS DATE )
						AND CAST (A.DT_FIM AS DATE )>= CAST (GETDATE() AS DATE)

						--data >= data_inicio and data  <= data_fim
						),0);

	--CAPTURANDO VALOR TABELA E OFERTA PARA AVALIACAO DE DESCONTO
	IF @ZERA_DESC_OFERTA =0 
		BEGIN
			SELECT @VLR_TABELA = VLR_TABELA
				,@VLR_OFERTA = CASE 
					WHEN @PGTO_AVISTA = 1
						AND PRECO.VLR_OFERTA_AVISTA > 0
						THEN CASE 
								WHEN PRECO.VLR_OFERTA < PRECO.VLR_OFERTA_AVISTA
									THEN PRECO.VLR_OFERTA
								ELSE PRECO.VLR_OFERTA_AVISTA
								END
					ELSE VLR_OFERTA
					END
				,@FLAG_SOBREPOE_DESCONTOS = PRECO.FLAG_SOBREPOE_DESCONTOS
			FROM EST_PROD_PRECO PRECO
			WHERE PRECO.CD_EMP = @CD_EMP
				AND PRECO.CD_PROD = @CD_PROD
				AND PRECO.CD_FILIAL = @CD_FILIAL
		END;
	ELSE
		BEGIN
			SET @VLR_OFERTA=0
		END;

	IF @VLR_OFERTA > 0
	BEGIN
		SET @PERC_DESC_OFERTA = ROUND(((1 - (CAST(@VLR_OFERTA AS DECIMAL(15, 4)) / @VLR_TABELA)) * 100), 4);
		SET @PERC_DESC_OFERTA_MAX = CASE @PERMITE_DESC_OFERTA
				WHEN 1
					THEN @PERC_DESC_OFERTA + 0.0001
				ELSE @PERC_DESC_OFERTA
				END;

		INSERT INTO #TEMP_RS_TAB_DESC
		SELECT 0
			,6
			,1
			,@PERC_DESC_OFERTA
			,@PERC_DESC_OFERTA_MAX
			,1
			,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																								  
	END;

	--------------------------------------------------------------------------------------------------------------------------
	-- CAPTURANDO TABELAS DE DESCONTOS CADASTRADAS
	INSERT INTO #TEMP_RS_TIPO_DESC_CAD
	SELECT CD_TP_DESCONTO
	FROM EST_PROD_TBL_DESC  
   WHERE ORIG_VENDA IN ( 0 , @TP_ORIG_VENDA )    --->> GUSTAVO AQUI
	GROUP BY CD_TP_DESCONTO;

	-- CAPTURANDO TABELAS DE DESCONTOS CADASTRADAS
	INSERT INTO #TEMP_RS_TIPO_DESC_CAD
	SELECT CD_TP_DESCONTO
	FROM EST_PROD_TBL_DESC_QTDE
   WHERE ORIG_VENDA IN ( 0 , @TP_ORIG_VENDA )    --->> GUSTAVO AQUI
	GROUP BY CD_TP_DESCONTO;

	--PRINT 'DESCONTO ESPECIAL ' + CONVERT(VARCHAR,@DESCONTO_ESPECIAL)
	--VERIFICANDO SE EXISTE ALGUMA TABELA DE DESCONTO CADASTRADA
	IF EXISTS (
			SELECT *
			FROM #TEMP_RS_TIPO_DESC_CAD
			WHERE CD_TP_DESCONTO > 0
			)
		IF @ZERA_DESC_OFERTA = 0 ---- NO ZERAR DESCONTOS
		BEGIN
			-- VERIFICANDO MOEDAS ESPECIAIS CONVENIO E CREDIARIO
			IF (
					@CD_FRM_PGTO IN (
						SELECT CD_FRM_PGTO
						FROM EST_FORMA_PGTO
						WHERE DS_FRM_PGTO LIKE 'CREDI%'
							OR DS_FRM_PGTO LIKE 'CONV%'
						)
					OR @CD_FRM_PGTO IN (
						SELECT A.cd_frm_pgto
						FROM est_forma_pgto a 
						INNER JOIN est_forma_pgto_moeda b 
						ON a.cd_emp = b.cd_emp AND a.cd_frm_pgto = b.cd_frm_pgto 
						WHERE b.cd_tp_moeda = 5 and  sts_frm_pgto = 0
						)
					OR @CD_FRM_PGTO = 0
					)
			BEGIN
				--PRINT 'VERIFICANDO DESCONTO SOMENTE CONVENIO A'
				-- CREDIARIO
				SET @DESCONTO_ESPECIAL = COALESCE((
							SELECT TOP 1 2 -- CREDIARIO
							FROM EST_FORMA_PGTO A
							INNER JOIN EST_FORMA_PGTO_MOEDA B ON A.CD_EMP = B.CD_EMP
								AND A.CD_FRM_PGTO = B.CD_FRM_PGTO
							WHERE A.CD_FRM_PGTO = @CD_FRM_PGTO
								AND B.CD_TP_MOEDA = 5
							), 3);

				IF @DESCONTO_ESPECIAL = 2
				BEGIN -- VERIFICANDO SE FORMA DE PAGAMENTO OU MODELO DE VENDA EXISGE SOMENTE DESCONTO CREDIARIO
					IF NOT (
							COALESCE((
									SELECT TOP 1 1
									FROM EST_FORMA_PGTO A
									WHERE A.CD_FRM_PGTO = @CD_FRM_PGTO
										AND A.REGRA_DESCONTO = 2
									), 0) = 1
							OR COALESCE((
									SELECT TOP 1 1
									FROM RC_CLI_CONV A
									WHERE A.CD_CONV = @CD_CONV
										AND FLAG_SOMENTE_DESC_CONTRATO = 1
									), 0) = 1
							OR COALESCE((
									SELECT TOP 1 1
									FROM RC_MDL_VENDA A
									WHERE A.CD_MDL_VD = @CD_MDL_VD_CREDIARIO
										AND FLAG_SOMENTE_DESC_CONTRATO = 1
									), 0) = 1
							)
					BEGIN
						SET @DESCONTO_ESPECIAL = 3;
					END;
				END;

				IF @DESCONTO_ESPECIAL = 3
				BEGIN
					SET @DESCONTO_ESPECIAL = COALESCE((
								SELECT TOP 1 1 -- CONVENIO
								FROM EST_FORMA_PGTO A
								INNER JOIN EST_FORMA_PGTO_MOEDA B ON A.CD_EMP = B.CD_EMP
									AND A.CD_FRM_PGTO = B.CD_FRM_PGTO
								WHERE A.CD_FRM_PGTO = @CD_FRM_PGTO
									AND B.CD_TP_MOEDA = 4
								), 3);

					--REGRA_DESCONTO = 1
					IF @DESCONTO_ESPECIAL = 1
					BEGIN -- VERIFICANDO SE FORMA DE PAGAMENTO OU MODELO DE VENDA EXISGE SOMENTE DESCONTO DE CONVENIO
						IF NOT (
								COALESCE((
										SELECT TOP 1 1
										FROM EST_FORMA_PGTO A
										WHERE A.CD_FRM_PGTO = @CD_FRM_PGTO
											AND A.REGRA_DESCONTO = 1
										), 0) = 1
								OR COALESCE((
										SELECT TOP 1 1
										FROM RC_MDL_VENDA A
										WHERE A.CD_MDL_VD = @CD_MDL_VD_CONVENIO
											AND FLAG_SOMENTE_DESC_CONTRATO = 1
										), 0) = 1
								OR COALESCE((
										SELECT TOP 1 1
										FROM RC_CLI_CONV A
										WHERE A.CD_CONV = @CD_CONV
											AND FLAG_SOMENTE_DESC_CONTRATO = 1
										), 0) = 1
								)
						BEGIN
							SET @DESCONTO_ESPECIAL = 3;
						END;
					END;
				END;

				IF @DESCONTO_ESPECIAL = 3
				BEGIN -- VERIFICANDO SE EH PARA USAR SOMENTE DESCONTO DA FORMA DE PAGAMENTO
					SET @DESCONTO_ESPECIAL = COALESCE((
								SELECT TOP 1 0
								FROM EST_FORMA_PGTO A
								WHERE A.CD_FRM_PGTO = @CD_FRM_PGTO
									AND A.REGRA_DESCONTO = 0
								), 3);
				END;
			END;
			ELSE
			BEGIN
				--PRINT 'VERIFICANDO DESCONTO SOMENTE CONVENIO B'
				IF (
						COALESCE((
								SELECT TOP 1 1
								FROM RC_CLI_CONV A
								WHERE CD_CONV = @CD_CONV
									AND FLAG_SOMENTE_DESC_CONTRATO = 1
								), 0) = 1
						)
				BEGIN
					SET @DESCONTO_ESPECIAL = 1;
				END;
			END;

			--PRINT 'DESCONTO ESPECIAL ' + CONVERT(VARCHAR,@DESCONTO_ESPECIAL)
			-- CAPTURANDO DESCONTO DE FORMA DE PAGAMENTO
			IF @DESCONTO_ESPECIAL = 3
				OR @DESCONTO_ESPECIAL = 0
			BEGIN
				-- CAPTURANDO DESCONTO DE FORMA DE PAGAMENTO
				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 18
						)
				BEGIN
					IF @CD_FRM_PGTO > 0
					BEGIN
						INSERT INTO #TEMP_RS_TAB_DESC
						SELECT CD_TBL_DESC
							,TP_DESC
							,FLAG_DESC_FIX
							,PERC_DESC
							,PERC_DESC_MAX
							,TP_NIVEL
							,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						 
						FROM UFD_EST_PROD_TBL_DESC_FORMA_PGTO(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FRM_PGTO, @IS_RECEITA , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT ); 
					END;
				END;
			END;-- FIM CAPTURANDO DESCONTO DE FORMA DE PAGAMENTO
					-- CAPTURANDO DESCONTO DE CONVENIO

			IF @DESCONTO_ESPECIAL = 3
				OR @DESCONTO_ESPECIAL = 1
			BEGIN
				-- VERIFICA SE VALIDA STATUS DE CREDITO PARA CONCEDER DESCONTO
				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 3
						)
				BEGIN
					IF @CD_CONV > 0
					BEGIN
						IF NOT EXISTS (
								SELECT 1
								FROM RC_CLI_CONV_RC_CLI
								WHERE CD_EMP = @CD_EMP
									AND CD_CONV = @CD_CONV
									AND CD_CLI = @CD_CLI
									AND STS_ATIVO = 0
								)
							SET @CD_CONV = 0;
						ELSE
						BEGIN
							IF @VALIDA_STS_CRED_CONV > 0
								AND @CD_CONV > 0
								IF NOT EXISTS (
										SELECT 1
										FROM RC_CLI_CONV_RC_CLI
										WHERE CD_EMP = @CD_EMP
											AND CD_CONV = @CD_CONV
											AND CD_CLI = @CD_CLI
											AND STS_CRED = 0
										)
									SET @CD_CONV = 0;

							IF @CD_CONV > 0
							BEGIN
								SELECT @CD_TBL_DESC = CD_TBL_DESC
									,@TP_DESC = TP_DESC
									,@FLAG_DESC_FIX = FLAG_DESC_FIX
									,@PERC_DESC = PERC_DESC
									,@PERC_DESC_MAX = CASE @FLAG_SOMENTE_DESCONTO_CONV
										WHEN 1
											THEN PERC_DESC_MAX
										ELSE PERC_DESC_MAX + 0.00001
										END
									,@TP_NIVEL = TP_NIVEL
									,@LIBERA_VD_CONV = LIBERA_VD_CONV
									,@EXCLUE_OFERTA = EXCLUE_OFERTA
									,@QT_MAX = QT_MAX
								FROM UFD_EST_PROD_TBL_DESC_CONV(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_CLI, @CD_CONV, @IS_RECEITA, @LIBERA_VD_CONV, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT ); 

								-- INSERINDO DESCONTO DE CONVENIO
								INSERT INTO #TEMP_RS_TAB_DESC
								SELECT @CD_TBL_DESC
									,@TP_DESC
									,@FLAG_DESC_FIX
									,@PERC_DESC
									,@PERC_DESC_MAX
									,@TP_NIVEL
									,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																				   

								-- SETANDO SE PRODUTO PODE SER VENDIDO EM CONVENIO E QUANTIDADE MAXIMA NO CONVENIO
								UPDATE #RS_RET
								   SET LIBERA_VD_CONV = @LIBERA_VD_CONV
									  ,QTDE_PROD_MAX_CONV = @QT_MAX
									  ,LIB_DESC_VERBA = CASE WHEN @FLAG_SOMENTE_DESCONTO_CONV = 1 THEN 1
															 ELSE LIB_DESC_VERBA
														 END;
									--REVOGADO
									--IF @EXCLUE_OFERTA > 0 
									--	UPDATE #RS_RET SET VLR_OFERTA = 0;
							 
							END;
						END;
					END;
				END;
			END;-- FIM CAPTURANDO DESCONTO DE CONVENIO
					-- CAPTURANDO DESCONTO DE CREDIARIO

			IF @DESCONTO_ESPECIAL = 3
				OR @DESCONTO_ESPECIAL = 2
			BEGIN
				IF @CLI_CREDIARIO = 1
				BEGIN
					IF @CD_MDL_VD_CREDIARIO > 0
					BEGIN
						-- VALIDANDO TABELA DESCONTO DE CREDIARIO
						IF EXISTS (
								SELECT *
								FROM #TEMP_RS_TIPO_DESC_CAD
								WHERE CD_TP_DESCONTO = 19
								)
						BEGIN
							IF @VALIDA_STS_CRED_CREDIARIO > 0 -- VALIDA ESTADOS DE CREDITO
								IF EXISTS (
										SELECT 1
										FROM RC_CLI_CREDIARIO
										WHERE CD_EMP = @CD_EMP
											AND CD_CLI = @CD_CLI
											AND (
												STS_CRED <> 0
												OR CD_MDL_VD < 1
												)
										)
									SET @CLI_CREDIARIO = 0;

							IF @CLI_CREDIARIO = 1
							BEGIN -- BUSCANDO DESCONTO
								INSERT INTO #TEMP_RS_TAB_DESC
								SELECT CD_TBL_DESC
									,TP_DESC
									,FLAG_DESC_FIX
									,PERC_DESC
									,PERC_DESC_MAX
									,TP_NIVEL
									,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																				   
								FROM UFD_EST_PROD_TBL_DESC_CREDIARIO(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_MDL_VD_CREDIARIO, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT );  
									--		PRINT 'TESTE DA FUNCAO '
							END;
						END;
					END;
				END;
			END;

			IF @DESCONTO_ESPECIAL = 3 -- MELHOR DESCONTO PARA CLIENTE
			BEGIN
			-- FIM CAPTURANDO DESCONTO DE CREDIARIO
			-- CAPTURANDO DESCONTO DE PRODUTO
			IF EXISTS (
					SELECT *
					FROM #TEMP_RS_TIPO_DESC_CAD
					WHERE CD_TP_DESCONTO = 1
					)
			BEGIN
				INSERT INTO #TEMP_RS_TAB_DESC
				SELECT CD_TBL_DESC
					,TP_DESC
					,FLAG_DESC_FIX
					,PERC_DESC
					,PERC_DESC_MAX
					,TP_NIVEL
					,0  AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																								
				FROM UFD_EST_PROD_TBL_DESC_CADASTRO_PROD(@CD_EMP, @CD_FILIAL, @CD_PROD, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT); 
			END;

			-- CAPTURANDO DESCONTO DE FIDELIDADE
			IF EXISTS (
					SELECT *
					FROM #TEMP_RS_TIPO_DESC_CAD
					WHERE CD_TP_DESCONTO = 4
					)
			BEGIN
				IF @IS_CLI_FIDEL = 1
				BEGIN
					INSERT INTO #TEMP_RS_TAB_DESC
					SELECT CD_TBL_DESC
						,TP_DESC
						,FLAG_DESC_FIX
						,PERC_DESC
						,PERC_DESC_MAX
						,TP_NIVEL
						,0  AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					FROM UFD_EST_PROD_TBL_DESC_FIDELIDADE(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_CLI, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT );  
				END;
			END;

			-- CAPTURANDO DESCONTO POR CARGO
			IF EXISTS (
					SELECT *
					FROM #TEMP_RS_TIPO_DESC_CAD
					WHERE CD_TP_DESCONTO = 25
					)
			BEGIN
				INSERT INTO #TEMP_RS_TAB_DESC
				SELECT CD_TBL_DESC
					,25 TP_DESC
					,0 FLAG_DESC_FIX
					,PERC_DESC
					,PERC_DESC_MAX
					,TP_NIVEL
					,0  AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							   
				FROM UFD_EST_PROD_TBL_DESC_CARGO(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_VEND, @CD_FRM_PGTO );  
			END;

			IF EXISTS ( SELECT * FROM #TEMP_RS_TIPO_DESC_CAD WHERE CD_TP_DESCONTO = 24 )
			BEGIN
				-- CAPTURANDO DESCONTO DE PAGE LEVE
				SET @CD_TBL_DESC = - 1;

				IF @QTDE_PROD > 1
				BEGIN
					SELECT @CD_TBL_DESC = CD_TBL_DESC
						  ,@TP_DESC = TP_DESC
						  ,@QTDE_PAG = QTDE_PAG
						  ,@FLAG_DESC_FIX = 0
						  ,@PERC_DESC = PERC_DESC
						  ,@PERC_DESC_MAX = PERC_DESC_MAX
						  ,@TP_NIVEL = TP_NIVEL
						  ,@AGREGACAO = AGREGACAO
						  ,@TP_TBL_DESC = 0--  AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					  FROM UFD_EST_PROD_TBL_DESC_LEVE_PAGUE(@CD_EMP, @CD_FILIAL, @CD_PROD, @QTDE_PROD, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT );  

					IF @CD_TBL_DESC > - 1
					BEGIN
						IF @AGREGACAO = 1
						BEGIN
							UPDATE #TEMP_RS_TAB_DESC
							   SET PERC_DESC = ROUND(((@QTDE_PAG * PERC_DESC + (@QTDE_PROD - @QTDE_PAG) * 100.) / @QTDE_PROD), 4)
								  ,PERC_DESC_MAX = ROUND(((@QTDE_PAG * PERC_DESC_MAX + (@QTDE_PROD - @QTDE_PAG) * 100.) / @QTDE_PROD), 4)
								  ,CD_TBL_DESC = @CD_TBL_DESC
								  ,TP_DESC = @TP_DESC
							--	  ,QTDE_PAG = @QTDE_PAG
								  ,TP_NIVEL = @TP_NIVEL
								  ,TP_TBL_DESC = 1  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																				  
							--    ,AGREGACAO = @AGREGACAO;
								 
						END;
						ELSE
						BEGIN
							INSERT INTO #TEMP_RS_TAB_DESC
							SELECT @CD_TBL_DESC
								  ,@TP_DESC
								  ,@FLAG_DESC_FIX
								  ,@PERC_DESC
								  ,@PERC_DESC_MAX
								  ,@TP_NIVEL
								  ,1 AS TP_TBL_DESC;   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						 
						END;
					END;
				END;
			END;


				-- CAPTURANDO DESCONTO DE ANIVERSARIO 	
				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 11
						)
				BEGIN
					INSERT INTO #TEMP_RS_TAB_DESC
					SELECT CD_TBL_DESC
						,TP_DESC
						,FLAG_DESC_FIX
						,PERC_DESC
						,PERC_DESC_MAX
						,TP_NIVEL
						,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					FROM UFD_EST_PROD_TBL_DESC_ANIVERSARIO(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_CLI, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT );  
				END;

				-- CAPTURANDO DESCONTO DE CLASSIFICACAO CLIENTE
				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 12
						)
				BEGIN
					INSERT INTO #TEMP_RS_TAB_DESC
					SELECT CD_TBL_DESC
						,TP_DESC
						,FLAG_DESC_FIX
						,PERC_DESC
						,PERC_DESC_MAX
						,TP_NIVEL
						,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					FROM UFD_EST_PROD_TBL_DESC_CLASSIFICACAO(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_CLI, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT );  
				END;

				-- CAPTURANDO DESCONTO DE PROGRAMADO
				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 23
						)
				BEGIN
					INSERT INTO #TEMP_RS_TAB_DESC
					SELECT CD_TBL_DESC
						,TP_DESC
						,FLAG_DESC_FIX
						,PERC_DESC
						,PERC_DESC_MAX
						,TP_NIVEL
						,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					FROM UFD_EST_PROD_TBL_DESC_PROGRAMADO(@CD_EMP, @CD_FILIAL, @CD_PROD, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT);  
				END;

				-- CAPTURANDO DESCONTO DE TELEVENDAS
				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 15
						)
				BEGIN
					IF @APPLICATION = 1
					BEGIN
						INSERT INTO #TEMP_RS_TAB_DESC
						SELECT CD_TBL_DESC
							,TP_DESC
							,FLAG_DESC_FIX
							,PERC_DESC
							,PERC_DESC_MAX
							,TP_NIVEL
							,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto																						 
						FROM UFD_EST_PROD_TBL_DESC_TELEVENDAS(@CD_EMP, @CD_FILIAL, @CD_PROD, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT); 
					END;
				END;

				--CAPTURANDO DESCONTO DE PRODUTOS PRE-VENCIDOS
				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 26
						)
				BEGIN
					INSERT INTO #TEMP_RS_TAB_DESC
					SELECT CD_TBL_DESC
						,26 TP_DESC
						,0 FLAG_DESC_FIX
						,PERC_DESC
						,PERC_DESC_MAX
						,TP_NIVEL
						,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					FROM UFD_EST_PROD_TBL_DESC_PRE_VENCIDOS(@CD_EMP, @CD_FILIAL, @EAN );--, @CD_FRM_PGTO );  
				END;

				-- CAPTURANDO DESCONTO DE FABRICA
				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 13
						)
				BEGIN
					INSERT INTO #TEMP_RS_TAB_DESC
					SELECT CD_TBL_DESC
						,TP_DESC
						,FLAG_DESC_FIX
						,PERC_DESC
						,PERC_DESC_MAX
						,TP_NIVEL
						,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					FROM UFD_EST_PROD_TBL_DESC_PRECO_FABRICA(@CD_EMP, @CD_FILIAL, @CD_CLI, @CD_PROD, @CD_FRM_PGTO ); 
				END;

				IF EXISTS (
						SELECT *
						FROM #TEMP_RS_TIPO_DESC_CAD
						WHERE CD_TP_DESCONTO = 28
						)
				BEGIN
					INSERT INTO #TEMP_RS_TAB_DESC
					SELECT CD_TBL_DESC
						,TP_DESC
						,FLAG_DESC_FIX
						,PERC_DESC
						,PERC_DESC_MAX
						,TP_NIVEL
						,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					FROM UFD_EST_PROD_TBL_DESC_ESPECIAL_CLIENTE(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_CLI , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT);  
				END;
				
			
			
				-- CAPTURANDO DESCONTO PARCEIRO
				IF ( @CD_PARCEIRO > 0  ) 
				BEGIN 
				-------------------------------------------------------------------------------------------------------------------------------     
				-- VERIFICA SE O PARCEIRO USA TABELAS EXCLUSIVAS 0 - NO | 1 - SIM 
				SET @USA_DESC_EXCLUSIVO = COALESCE(( SELECT DESC_EXCLUSIVO_PARCEIRO FROM GLB_PARCEIRO WHERE CD_PARCEIRO = @CD_PARCEIRO ), 0);
	 
				
				
				-- VERIFICA SE EXISTE ALGUMA TABELA EXCLUSIVA CONFIGURADA  0 - NAO | 1 - SIM 
				SET @TABELAS_EXCLUSIVAS = COALESCE(( SELECT TOP 1 1 FROM GLB_PARCEIRO_EST_PROD_TBL_DESC WHERE CD_PARCEIRO = @CD_PARCEIRO    ), 0);   
		 


					IF EXISTS ( SELECT * FROM #TEMP_RS_TIPO_DESC_CAD WHERE CD_TP_DESCONTO = 31)
					BEGIN
						INSERT INTO #TEMP_RS_TAB_DESC
							SELECT CD_TBL_DESC
								  ,TP_DESC
								  ,FLAG_DESC_FIX
								  ,PERC_DESC
								  ,PERC_DESC_MAX
								  ,TP_NIVEL
								  ,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																				   
							FROM UFD_EST_PROD_TBL_DESC_PARCEIRO (@CD_EMP , @CD_FILIAL , @CD_PARCEIRO , @CD_PROD , @IS_RECEITA , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT); 
					END;
				END;
				-------------------------------------------------------------------------------------------------------------------------------    
			END;

			-- CAPTURANDO DESCONTO DE QUANTIDADE ACIMA
			IF EXISTS ( SELECT * FROM #TEMP_RS_TIPO_DESC_CAD WHERE CD_TP_DESCONTO = 14 )
			BEGIN
				
				SET @CD_TBL_DESC= -1

				SELECT @CD_TBL_DESC = CD_TBL_DESC
					  ,@TP_DESC     = TP_DESC
					  ,@FLAG_DESC_FIX = FLAG_DESC_FIX
					  ,@PERC_DESC = PERC_DESC
					  ,@PERC_DESC_MAX = PERC_DESC_MAX
					  ,@TP_NIVEL = TP_NIVEL
					  ,@AGREGACAO = AGREGACAO
					  ,@TP_TBL_DESC = 1     --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							   
				  FROM UFD_EST_PROD_TBL_DESC_QTDE(@CD_EMP, @CD_FILIAL, @CD_CLI, @CD_PROD, @QTDE_PROD, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT); 

				IF @CD_TBL_DESC > - 1
				BEGIN
					IF @AGREGACAO = 1
					BEGIN
						UPDATE #TEMP_RS_TAB_DESC
						   SET PERC_DESC = 100 - ((100 - (100 * PERC_DESC / 100)) - ((100 - (100 * PERC_DESC / 100)) * (@PERC_DESC / 100)))
							  ,PERC_DESC_MAX = 100 - ((100 - (100 * PERC_DESC_MAX / 100)) - ((100 - (100 * PERC_DESC_MAX / 100)) * (@PERC_DESC_MAX / 100)))
							  ,CD_TBL_DESC = @CD_TBL_DESC
							  ,TP_DESC  = @TP_DESC
							  ,TP_NIVEL = @TP_NIVEL
							  ,TP_TBL_DESC = 1;  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						  
					END;
					ELSE
					BEGIN
						INSERT INTO #TEMP_RS_TAB_DESC
						SELECT @CD_TBL_DESC
							,@TP_DESC
							,@FLAG_DESC_FIX
							,@PERC_DESC
							,@PERC_DESC_MAX
							,@TP_NIVEL
							,1 AS TP_TBL_DESC;   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						  
					END;
				END;
			END;
			
		-------ELSE -- ZERAR DESCONTOS > 0, ENTO NO ZERA POR QUANTIDADE/CAMPANHA/PBM/PRE-VENCIDOS
		--	--CAPTURANDO DESCONTO DE PRODUTOS PRE-VENCIDOS
		--	IF EXISTS (
		--			SELECT *
		--			FROM #TEMP_RS_TIPO_DESC_CAD
		--			WHERE CD_TP_DESCONTO = 26
		--			)
		--	BEGIN --- AQUI
		--		INSERT INTO #TEMP_RS_TAB_DESC
		--		SELECT CD_TBL_DESC
		--			,26 TP_DESC
		--			,0 FLAG_DESC_FIX
		--			,PERC_DESC
		--			,PERC_DESC_MAX
		--			,TP_NIVEL
		--			,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
		--		FROM UFD_EST_PROD_TBL_DESC_PRE_VENCIDOS(@CD_EMP, @CD_FILIAL, @EAN );--, @CD_FRM_PGTO );  
		--	END; ---AQUI
				
		--	-- CAPTURANDO DESCONTO DE QUANTIDADE ACIMA
		--	IF EXISTS ( SELECT * FROM #TEMP_RS_TIPO_DESC_CAD WHERE CD_TP_DESCONTO = 14 )
		--		BEGIN --- AQUI
					
		--			SET @CD_TBL_DESC= -1

		--			SELECT @CD_TBL_DESC = CD_TBL_DESC
		--				  ,@TP_DESC     = TP_DESC
		--				  ,@FLAG_DESC_FIX = FLAG_DESC_FIX
		--				  ,@PERC_DESC = PERC_DESC
		--				  ,@PERC_DESC_MAX = PERC_DESC_MAX
		--				  ,@TP_NIVEL = TP_NIVEL
		--				  ,@AGREGACAO = AGREGACAO
		--				  ,@TP_TBL_DESC = 1     --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							   
		--			  FROM UFD_EST_PROD_TBL_DESC_QTDE(@CD_EMP, @CD_FILIAL, @CD_CLI, @CD_PROD, @QTDE_PROD, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT); 

		--			IF @CD_TBL_DESC > - 1
		--				BEGIN
		--					IF @AGREGACAO = 1
		--						BEGIN
		--							UPDATE #TEMP_RS_TAB_DESC
		--							   SET PERC_DESC = 100 - ((100 - (100 * PERC_DESC / 100)) - ((100 - (100 * PERC_DESC / 100)) * (@PERC_DESC / 100)))
		--								  ,PERC_DESC_MAX = 100 - ((100 - (100 * PERC_DESC_MAX / 100)) - ((100 - (100 * PERC_DESC_MAX / 100)) * (@PERC_DESC_MAX / 100)))
		--								  ,CD_TBL_DESC = @CD_TBL_DESC
		--								  ,TP_DESC  = @TP_DESC
		--								  ,TP_NIVEL = @TP_NIVEL
		--								  ,TP_TBL_DESC = 1;  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						  
		--						END;
		--					ELSE
		--						BEGIN
		--							INSERT INTO #TEMP_RS_TAB_DESC
		--							SELECT @CD_TBL_DESC
		--								,@TP_DESC
		--								,@FLAG_DESC_FIX
		--								,@PERC_DESC
		--								,@PERC_DESC_MAX
		--								,@TP_NIVEL
		--								,1 AS TP_TBL_DESC;   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						  
		--						END;
		--				END;
		--		END;	--- AQUI
		END;


		IF @ZERA_DESC_OFERTA <> 0
		BEGIN

			IF EXISTS ( SELECT * FROM #TEMP_RS_TIPO_DESC_CAD WHERE CD_TP_DESCONTO = 24 )
			BEGIN
				-- CAPTURANDO DESCONTO DE PAGE LEVE
				SET @CD_TBL_DESC = - 1;

				IF @QTDE_PROD > 1
				BEGIN
					SELECT @CD_TBL_DESC = CD_TBL_DESC
						  ,@TP_DESC = TP_DESC
						  ,@QTDE_PAG = QTDE_PAG
						  ,@FLAG_DESC_FIX = 0
						  ,@PERC_DESC = PERC_DESC
						  ,@PERC_DESC_MAX = PERC_DESC_MAX
						  ,@TP_NIVEL = TP_NIVEL
						  ,@AGREGACAO = AGREGACAO
						  ,@TP_TBL_DESC = 0--  AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
					  FROM UFD_EST_PROD_TBL_DESC_LEVE_PAGUE(@CD_EMP, @CD_FILIAL, @CD_PROD, @QTDE_PROD, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT );  

					IF @CD_TBL_DESC > - 1
					BEGIN
						IF @AGREGACAO = 1
						BEGIN
							UPDATE #TEMP_RS_TAB_DESC
							   SET PERC_DESC = ROUND(((@QTDE_PAG * PERC_DESC + (@QTDE_PROD - @QTDE_PAG) * 100.) / @QTDE_PROD), 4)
								  ,PERC_DESC_MAX = ROUND(((@QTDE_PAG * PERC_DESC_MAX + (@QTDE_PROD - @QTDE_PAG) * 100.) / @QTDE_PROD), 4)
								  ,CD_TBL_DESC = @CD_TBL_DESC
								  ,TP_DESC = @TP_DESC
							--	  ,QTDE_PAG = @QTDE_PAG
								  ,TP_NIVEL = @TP_NIVEL
								  ,TP_TBL_DESC = 1  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																				  
							--    ,AGREGACAO = @AGREGACAO;
								 
						END;
						ELSE
						BEGIN
							INSERT INTO #TEMP_RS_TAB_DESC
							SELECT @CD_TBL_DESC
								  ,@TP_DESC
								  ,@FLAG_DESC_FIX
								  ,@PERC_DESC
								  ,@PERC_DESC_MAX
								  ,@TP_NIVEL
								  ,1 AS TP_TBL_DESC;   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						 
						END;
					END;
				END;
			END;

		-----ELSE -- ZERAR DESCONTOS > 0, ENTO NO ZERA POR QUANTIDADE/CAMPANHA/PBM/PRE-VENCIDOS
			--CAPTURANDO DESCONTO DE PRODUTOS PRE-VENCIDOS
			IF EXISTS (
					SELECT *
					FROM #TEMP_RS_TIPO_DESC_CAD
					WHERE CD_TP_DESCONTO = 26
					)
			BEGIN --- AQUI
				INSERT INTO #TEMP_RS_TAB_DESC
				SELECT CD_TBL_DESC
					,26 TP_DESC
					,0 FLAG_DESC_FIX
					,PERC_DESC
					,PERC_DESC_MAX
					,TP_NIVEL
					,0 AS TP_TBL_DESC   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							
				FROM UFD_EST_PROD_TBL_DESC_PRE_VENCIDOS(@CD_EMP, @CD_FILIAL, @EAN );--, @CD_FRM_PGTO );  
			END; ---AQUI
				
			-- CAPTURANDO DESCONTO DE QUANTIDADE ACIMA
			IF EXISTS ( SELECT * FROM #TEMP_RS_TIPO_DESC_CAD WHERE CD_TP_DESCONTO = 14 )
				BEGIN --- AQUI
					
					SET @CD_TBL_DESC= -1

					SELECT @CD_TBL_DESC = CD_TBL_DESC
							,@TP_DESC     = TP_DESC
							,@FLAG_DESC_FIX = FLAG_DESC_FIX
							,@PERC_DESC = PERC_DESC
							,@PERC_DESC_MAX = PERC_DESC_MAX
							,@TP_NIVEL = TP_NIVEL
							,@AGREGACAO = AGREGACAO
							,@TP_TBL_DESC = 1     --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																							   
						FROM UFD_EST_PROD_TBL_DESC_QTDE(@CD_EMP, @CD_FILIAL, @CD_CLI, @CD_PROD, @QTDE_PROD, @IS_RECEITA, @CD_FRM_PGTO , @TP_ORIG_VENDA, @USA_DESCONTO_PROPZ_IDENT); 

					IF @CD_TBL_DESC > - 1
						BEGIN
							IF @AGREGACAO = 1
								BEGIN
									UPDATE #TEMP_RS_TAB_DESC
										SET PERC_DESC = 100 - ((100 - (100 * PERC_DESC / 100)) - ((100 - (100 * PERC_DESC / 100)) * (@PERC_DESC / 100)))
											,PERC_DESC_MAX = 100 - ((100 - (100 * PERC_DESC_MAX / 100)) - ((100 - (100 * PERC_DESC_MAX / 100)) * (@PERC_DESC_MAX / 100)))
											,CD_TBL_DESC = @CD_TBL_DESC
											,TP_DESC  = @TP_DESC
											,TP_NIVEL = @TP_NIVEL
											,TP_TBL_DESC = 1;  --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						  
								END;
							ELSE
								BEGIN
									INSERT INTO #TEMP_RS_TAB_DESC
									SELECT @CD_TBL_DESC
										,@TP_DESC
										,@FLAG_DESC_FIX
										,@PERC_DESC
										,@PERC_DESC_MAX
										,@TP_NIVEL
										,1 AS TP_TBL_DESC;   --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																						  
								END;
						END;
				END;	--- AQUI
		END;
	--EXEC [P_EST_PROD_DESCONTOS] 1,1, 3273, 0, '', 0, 1, 1, 0, 0, 0,0 
	--SELECT * FROM #TEMP_RS_TAB_DESC
	--BAIXANDO DESCONTO SUPERIOR AO LIMITE REMOVIDO

	IF @FLAG_SOBREPOE_DESCONTOS > 0 AND @VLR_OFERTA > 0
	BEGIN
		--CAPTURANDO O MELHOR DESCONTO
		SELECT TOP 1 @CD_TBL_DESC = CD_TBL_DESC
			  ,@TP_DESC = TP_DESC
			  ,@FLAG_DESC_FIX = FLAG_DESC_FIX
			  ,@PERC_DESC = PERC_DESC
			  ,@PERC_DESC_MAX = PERC_DESC_MAX
			  ,@TP_NIVEL = TP_NIVEL
			  ,@TP_TBL_DESC = TP_TBL_DESC				
		  FROM #TEMP_RS_TAB_DESC
		 WHERE TP_DESC = 6
		 ORDER BY PERC_DESC DESC
		         ,PERC_DESC_MAX DESC
			     ,TP_NIVEL DESC;
	END;
	ELSE
		IF @FLAG_SOMENTE_DESCONTO_CONV = 1 /*Liberar apenas os descontos do convnio (Exceto tablide)*/
			BEGIN
				SELECT TOP 1 @CD_TBL_DESC = CD_TBL_DESC
				      ,@TP_DESC = TP_DESC
				      ,@FLAG_DESC_FIX = FLAG_DESC_FIX
				      ,@PERC_DESC = PERC_DESC
				      ,@PERC_DESC_MAX = PERC_DESC_MAX
				      ,@TP_NIVEL = TP_NIVEL
					  ,@TP_TBL_DESC = TP_TBL_DESC		 
				  FROM #TEMP_RS_TAB_DESC
				 WHERE TP_DESC IN (3,6) /*(Exceto tablide) Ou seja, o tabloide tem que considerado tambm*/
				 ORDER BY PERC_DESC DESC
				    	 ,PERC_DESC_MAX DESC
				  	     ,TP_NIVEL DESC;
			END;
			ELSE
			IF (@CD_PARCEIRO > 0 AND @USA_DESC_EXCLUSIVO = 1 )
			    BEGIN
			    	SELECT TOP 1 @CD_TBL_DESC = CD_TBL_DESC
			    		   ,@TP_DESC = TP_DESC
			    		   ,@FLAG_DESC_FIX = FLAG_DESC_FIX
			    		   ,@PERC_DESC = PERC_DESC
			    		   ,@PERC_DESC_MAX = PERC_DESC_MAX
			    		   ,@TP_NIVEL = TP_NIVEL
						   ,@TP_TBL_DESC = TP_TBL_DESC	  
			    	  FROM #TEMP_RS_TAB_DESC
					 WHERE TP_DESC = 31
			    	 ORDER BY PERC_DESC DESC
			    			 ,PERC_DESC_MAX DESC
			    			 ,TP_NIVEL DESC;
			     END;
				 ELSE 
					BEGIN
						SELECT TOP 1 @CD_TBL_DESC = CD_TBL_DESC
							   ,@TP_DESC = TP_DESC
							   ,@FLAG_DESC_FIX = FLAG_DESC_FIX
							   ,@PERC_DESC = PERC_DESC
							   ,@PERC_DESC_MAX = PERC_DESC_MAX
							   ,@TP_NIVEL = TP_NIVEL
							   ,@TP_TBL_DESC = TP_TBL_DESC   
						  FROM #TEMP_RS_TAB_DESC
						 ORDER BY PERC_DESC DESC
								 ,PERC_DESC_MAX DESC
								 ,TP_NIVEL DESC;
					END;

	--CORRECOES DE DESCONTOS
	/* NAO LIMITAR DESCONTOS CONVENIO, OFERTA, PRE-FATURA, CADASTRO, FIDELIDADE, QUANTIDADE ACIMA OU LEVE PAGUE*/
	IF ( @TP_DESC IN ( SELECT CD_TP_DESCONTO FROM GLB_TP_DESCONTO_LIMITE_EXCESSAO WHERE FLAG_NAO_LIMITAR_DESCONTO = 1) AND @PERC_DESC_LIMITE < @PERC_DESC_MAX )
	BEGIN
		IF (@PERC_DESC_LIMITE = 0)
		BEGIN
			SET @PERC_DESC_LIMITE = 100;
		END;
		ELSE
		BEGIN
			SET @PERC_DESC_LIMITE = @PERC_DESC_MAX;
		END;
	END;

	SET @PERC_DESC_LIMITE = CASE @PERC_DESC_LIMITE WHEN 0 THEN 100 
						         ELSE @PERC_DESC_LIMITE
							 END;
	SET @PERC_DESC_MAX = CASE WHEN @PERC_DESC_MAX = 0 THEN @PERC_DESC
							  WHEN @PERC_DESC_MAX > @PERC_DESC_LIMITE THEN @PERC_DESC_LIMITE
							  ELSE @PERC_DESC_MAX
						  END;
	SET @PERC_DESC = CASE WHEN @PERC_DESC > @PERC_DESC_MAX THEN @PERC_DESC_MAX
						  ELSE @PERC_DESC
					  END;

	UPDATE #RS_RET
	   SET FIXA_DESCONTO = CASE @PERC_DESC WHEN @PERC_DESC_MAX THEN 1
								ELSE 0
							END
		,TP_DESCONTO = @TP_DESC
		,VLR_ECONOMIA = ROUND((VLR_TABELA * (@PERC_DESC / 100)), 2)
		,DS_DESCONTO = DBO.UFD_DESCRICAO_DESC(@TP_DESC, @CD_TBL_DESC, @TP_NIVEL)
		,CD_TBL_DESC = @CD_TBL_DESC
		,TP_NIVEL = @TP_NIVEL
		,PERC_DESC = @PERC_DESC
		,MAIOR_PERC_DESC = @PERC_DESC_MAX
		,PERC_DESC_LIMITE = @PERC_DESC_LIMITE
		,LIBERA_VD_CONV = @LIBERA_VD_CONV
		,TP_TBL_DESC = @TP_TBL_DESC;     --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																												  

	--REMOVE DESCONTO PRODUTOS 
	IF (((SELECT 1 FROM #RS_RET WHERE PERC_DESC < 0 ) = 1 ) OR (( SELECT TP_PROD FROM EST_PROD_CPL WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL AND CD_PROD = @CD_PROD ) NOT IN (0,9,11)))
		UPDATE #RS_RET
		SET TP_DESCONTO = 0
			,VLR_ECONOMIA = 0
			,DS_DESCONTO = 'SEM DESCONTO SEM DEFINICAO DE NIVEL'
			,CD_TBL_DESC = 0
			,TP_NIVEL = 0
			,PERC_DESC = 0
			,MAIOR_PERC_DESC = 0
			,LIBERA_VD_CONV = LIBERA_VD_CONV
			,TP_TBL_DESC = 3;     --( 0 - Tabela desconto Percentual/ 1 - Pague e Leve / 2 - Campanha / 3 - Sem desconto)																									

	/*  IF @TP_PROD=9
	   UPDATE A
	   SET    
		  A.PERC_DESC = 0, 
		  A.MAIOR_PERC_DESC = 0,
		  A.DS_DESCONTO	= '',
		  A.CD_TBL_DESC	= 0,
		  A.TP_NIVEL = 0
	   FROM   #RS_RET A;

*/
	--EXEC [P_EST_PROD_DESCONTOS] 1,1, 3273, 0, '', 0, 1, 1, 0, 0, 0,0   


	/*CAPTURANDO EAN*/
	
	UPDATE R
	SET EAN = ISNULL(C.CD_BARRA,'')
	FROM #RS_RET R
	OUTER APPLY (SELECT TOP 1 CD_BARRA
				 FROM est_prod_cd_barra C
				 WHERE C.CD_PROD = R.CD_PROD
				 ORDER BY DT_CAD DESC) C
	
	
	
	-- RETORNANDO CONSULTA DE PRODUTO  
	SELECT '10/05/2024 00:00' AS VERSAO
		,CD_EMP
		,CD_FILIAL
		,CD_PROD
		,DS_PROD
		,NM_FABRIC
		,VLR_TABELA
		,VLR_OFERTA = CASE WHEN @SOBREPOE_PRECO_OFERTA = 1 THEN (VLR_TABELA - VLR_ECONOMIA)
						   ELSE 0
					   END
		,QTDE_PONTO_FIDEL
		,CTR_PMC
		,LIB_DESC_VERBA AS FLAG_VERBA_DESCON
		,FLAG_REQUER_RECEIT
		,FLAG_ALTERAR_PRECO
		,PROD_USO_CONT
		,TP_PROD
		,VLR_CUSTO
		,CD_GRP
		,QTD_PONTO_VENDA
		,LMT_PROD_PONTO_VENDA
		,APRES_QT_VD
		,QTDE_ESTOQUE
		,DS_TIPO_RECEITA
		,DS_COR_RECEITA
		,PERC_DESC_LIMITE
		,CD_TRIB_FC
		,PERC_ICMS_N_CONT_ESTA
		,PERC_RED_VD
		,LIBERA_VD_CONV
		,QTDE_PROD_MAX_CONV
		,FIXA_DESCONTO AS PERC_DESC_FIX
		,TP_DESCONTO
		,VLR_ECONOMIA
		,DS_DESCONTO
		,CD_TBL_DESC
		,TP_NIVEL
		,PERC_DESC
		,MAIOR_PERC_DESC
		,PRODUTO_CONTROLADO
		,VLR_PMC
		,FLAG_DESCONTO_TICKET_BLQ
		,PERC_DESC_FIDEL_MAX
		,PROMO_INDUSTRIA
		,PERC_DESC_ANIVER
		,PERC_DESC_CLAS
		,VLR_DESC_FABRIC
		,CAMPANHA
		,QTDE_PROD_CAMPANHA
		,FLAG_BLOQUEIA_DESCONTO
		,PERC_DESC_POS_PBM
		,CD_FAMILIA
		,NCM_PROD
		,NR_REG_MS
		,TP_TBL_DESC
		,QTDE_LIMITE_VENDA_FAMILIA	
		,DS_FAMILIA
		,PERC_PIS
		,PERC_COFINS
		,EAN
	FROM #RS_RET;

	RETURN;
END;
GO


